/*
 ͻ
 									    
   Source Code   :  MOUSE.H                                                
                                                                           
   Description   :  Header For Miscellaneous Mouse Functions               
                                                                           
 ͼ

 ͻ
                Prevent second reading of mouse definitions                
 ͼ
*/

#ifndef	___MOUSE_H
#define	___MOUSE_H

/*
 ͻ
                      Preprocessor #include Directives                     
 ͼ
*/

#include "dos.h"

/*
 ͻ
   ATTENTION:---> Define Conditional Compilation Directives <--:ATTENTION  
 Ķ
  To include any desired function in your application,   you must set the  
  defined constant for that function to non-zero,  else the function will  
  not be linked to your application.                                       
                                                                           
  The required definitions for each function can be located in the header  
  file.  Further, the defined conditional directives are only required by  
  the linker, and are used to avoid linking functions not required.  Once  
  defined, and linked,  the C/CPP function will undefine those constants.  
 ͼ
*/

#define __DETECT_MOUSE 		1
#define __MOUSE_SWITCH		1
#define __GET_MOUSE_XY		0
#define __SET_MOUSE_XY		0
#define __GET_MOUSE_PRESS	0
#define __GET_MOUSE_RELEASE	0
#define __SET_MOUSE_RANGE	0
#define __SET_GRAPHIC_MOUSE	0
#define __SET_TEXT_MOUSE	0
#define __GET_MOUSE_MOVEMENT	0
#define __SET_MOUSE_HANDLER	0
#define __MOUSE_LIGHT_PEN	0
#define __SET_MOUSE_SPEED	0
#define __SET_MOUSE_NO_AREA	0
#define __SET_MOUSE_THRESHOLD	0
#define __SWAP_MOUSE_HANDLER	0
#define	__MOUSE_BUFFER_SIZE	0
#define __MOUSE_STATE		0
#define __GET_MOUSE_HANDLER	0
#define __SET_MOUSE_TOUCH	0
#define __GET_MOUSE_TOUCH	0
#define __SET_MOUSE_INT_RATE	0
#define __SET_MOUSE_PAGE	0
#define __GET_MOUSE_PAGE	0
#define __DISABLE_MOUSE		0
#define __ENABLE_MOUSE		0
#define __RESET_MOUSE		0

/*
 ͻ
                            Function Prototypes                            
 ͼ
*/

#ifdef __cplusplus
extern "C" {
#endif

 #if __DETECT_MOUSE
 int  detect_mouse(void);
 #endif

 #if __MOUSE_SWITCH
 void mouse_switch(int mouse_on_off);
 #endif

 #if __GET_MOUSE_XY
 void get_mouse_xy(int &mouse_x, int &mouse_y, int &button);
 #endif

 #if __SET_MOUSE_XY
 void set_mouse_xy(int mouse_x, int mouse_y);
 #endif

 #if __GET_MOUSE_PRESS
 int  get_mouse_press(int &mouse_x, int &mouse_y, int &count, int button);
 #endif

 #if __GET_MOUSE_RELEASE
 int  get_mouse_release(int &mouse_x, int &mouse_y, int &count, int button);
 #endif

 #if __SET_MOUSE_RANGE
 void set_mouse_range(int mouse_x, int mouse_y, int mouse_x2, int mouse_y2);
 #endif

 #if __SET_GRAPHIC_MOUSE
 void set_graphic_mouse(int hotspot_x, int hotspot_y, int *mask);
 #endif

 #if __SET_TEXT_MOUSE
 void set_text_mouse(int type, int cursor_screen, int cursor_mask);
 #endif

 #if __GET_MOUSE_MOVEMENT
 void get_mouse_movement(int &mouse_x, int &mouse_y);
 #endif

 #if __SET_MOUSE_HANDLER               //-------> NOT TESTED * NOT TESTED
 void set_mouse_handler(int event_mask, int &handler);  //---> NOT TESTED
 #endif                                //-------> NOT TESTED * NOT TESTED

 #if __MOUSE_LIGHT_PEN                  //-------> NOT TESTED * NOT TESTED
 void mouse_light_pen(int pen_on_off);	//-------> NOT TESTED * NOT TESTED
 #endif                                 //-------> NOT TESTED * NOT TESTED

 #if __SET_MOUSE_SPEED
 void set_mouse_speed(int mouse_x, int mouse_y);
 #endif

 #if __SET_MOUSE_NO_AREA
 void set_mouse_no_area(int left_x, int top_y, int right_x, int bottom_y);
 #endif

 #if __SET_MOUSE_THRESHOLD
 void set_mouse_threshold(int speed_limit);
 #endif

 #if __SWAP_MOUSE_HANDLER               //-------> NOT TESTED * NOT TESTED
 void swap_mouse_handler(int &new_mask, int &old_mask, int far &handler);
 #endif                                 //-------> NOT TESTED * NOT TESTED

 #if __MOUSE_BUFFER_SIZE
 int  mouse_buffer_size(void);
 #endif

 #if __MOUSE_STATE                      //-------> NOT TESTED * NOT TESTED
 void mouse_state(int save_restore_alternate, int &buffer_state);
 #endif                                 //-------> NOT TESTED * NOT TESTED

 #if __GET_MOUSE_HANDLER                //-------> NOT TESTED * NOT TESTED
 int  get_mouse_handler(int event_mask, int &handler);
 #endif                                 //-------> NOT TESTED * NOT TESTED

 #if __SET_MOUSE_TOUCH
 void set_mouse_touch(int mouse_x, int mouse_y, int threshold);
 #endif

 #if __GET_MOUSE_TOUCH
 void get_mouse_touch(int &mouse_x, int &mouse_y, int &threshold);
 #endif

 #if __SET_MOUSE_INT_RATE                     //---> NOT TESTED * NOT TESTED
 void set_mouse_int_rate(int interrupt_rate); //---> NOT TESTED * NOT TESTED
 #endif                                       //---> NOT TESTED * NOT TESTED

 #if __SET_MOUSE_PAGE
 void set_mouse_page(int page);
 #endif

 #if __GET_MOUSE_PAGE
 int  get_mouse_page(void);
 #endif

 #if __DISABLE_MOUSE                          //---> NOT TESTED * NOT TESTED
 void disable_mouse(int &error_status, int &handler);
 #endif                                       //---> NOT TESTED * NOT TESTED

 #if __ENABLE_MOUSE                           //--> NOT TESTED * NOT TESTED
 void enable_mouse(void);                     //--> NOT TESTED * NOT TESTED
 #endif                                       //--> NOT TESTED * NOT TESTED

 #if __RESET_MOUSE
 int reset_mouse(void);
 #endif

#ifdef __cplusplus
}
#endif

/*
 ͻ
                               End of Header                               
 ͼ
*/

#endif						// ends #ifndef ___MOUSE_H
